<?php
session_start();
if (!isset($_SESSION['usuario_id'])) {
    header("Location: ../login.php");
    exit;
}

require_once '../config/config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$negocio_id = $_SESSION['negocio_id'];
$mensaje = "";

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $descripcion = $_POST['descripcion'];
    $precio = $_POST['precio'];
    $stock = $_POST['stock'];
    $categoria = $_POST['categoria'];
    $imagen_url = $_POST['imagen_url'];

    $stmt = $conn->prepare("INSERT INTO productos (negocio_id, nombre, descripcion, imagen_url, precio, stock, categoria) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssdis", $negocio_id, $nombre, $descripcion, $imagen_url, $precio, $stock, $categoria);

    if ($stmt->execute()) {
        $mensaje = "✅ Producto agregado correctamente.";
    } else {
        $mensaje = "❌ Error al agregar producto.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Agregar Producto</title>
  <link rel="stylesheet" href="https://code.getmdl.io/1.3.0/material.indigo-pink.min.css">
  <script defer src="https://code.getmdl.io/1.3.0/material.min.js"></script>
  <style>
    .container {
      max-width: 700px;
      margin: 90px auto 30px;
      padding: 2rem;
      background: white;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    .form-group {
      margin-bottom: 1.5rem;
    }
  </style>
</head>
<body>

<div class="mdl-layout mdl-js-layout mdl-layout--fixed-header">
  <header class="mdl-layout__header">
    <div class="mdl-layout__header-row">
      <span class="mdl-layout-title">Agregar Producto</span>
      <div class="mdl-layout-spacer"></div>
      <nav class="mdl-navigation">
        <a class="mdl-navigation__link" href="productos.php">← Volver</a>
        <a class="mdl-navigation__link" href="../logout.php">Cerrar sesión</a>
      </nav>
    </div>
  </header>

  <main class="mdl-layout__content">
    <div class="container">
      <?php if ($mensaje): ?>
        <p><?php echo $mensaje; ?></p>
      <?php endif; ?>

      <form method="POST">
        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label full-width">
          <input class="mdl-textfield__input" type="text" name="nombre" required>
          <label class="mdl-textfield__label">Nombre del producto</label>
        </div>

        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label full-width">
          <textarea class="mdl-textfield__input" name="descripcion" rows="3"></textarea>
          <label class="mdl-textfield__label">Descripción</label>
        </div>

        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
          <input class="mdl-textfield__input" type="number" name="precio" step="0.01" required>
          <label class="mdl-textfield__label">Precio</label>
        </div>

        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
          <input class="mdl-textfield__input" type="number" name="stock" required>
          <label class="mdl-textfield__label">Stock</label>
        </div>

        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label full-width">
          <input class="mdl-textfield__input" type="text" name="categoria">
          <label class="mdl-textfield__label">Categoría</label>
        </div>

        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label full-width">
          <input class="mdl-textfield__input" type="text" name="imagen_url">
          <label class="mdl-textfield__label">URL de imagen (opcional)</label>
        </div>

        <br>
        <button class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored" type="submit">
          Guardar Producto
        </button>
      </form>
    </div>
  </main>
</div>

</body>
</html>
