<?php
// conectar a la base de datos
require_once '../config/config.php';
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Recibir datos JSON
$data = json_decode(file_get_contents('php://input'), true);

// Validar
if (!isset($data['ids']) || !isset($data['nuevo_estado'])) {
    echo json_encode(['success' => false, 'message' => 'Faltan datos necesarios.']);
    exit;
}

$ids = $data['ids'];
$nuevo_estado = trim($data['nuevo_estado']);

// Validación extra opcional de seguridad
$estados_validos = ['pendiente', 'preparando', 'preparado', 'listoretiro', 'despachado', 'entregado', 'cancelado'];
if (!in_array($nuevo_estado, $estados_validos)) {
    echo json_encode(['success' => false, 'message' => 'Estado no permitido.']);
    exit;
}

// Asegurar que los IDs sean numéricos
$ids_limpios = array_map('intval', $ids);

// Preparar SQL
$ids_string = implode(',', $ids_limpios);
$query = "UPDATE pedidos SET estado = ? WHERE id IN ($ids_string)";

// Ejecutar
$stmt = $conn->prepare($query);
if (!$stmt) {
    echo json_encode(['success' => false, 'message' => 'Error en la preparación de la consulta.']);
    exit;
}

$stmt->bind_param("s", $nuevo_estado);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Pedidos actualizados exitosamente.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al actualizar los pedidos.']);
}

$stmt->close();
$conn->close();
?>