<?php
//require '/var/www/html/vendor/autoload.php';
require __DIR__ . '/../vendor/autoload.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

date_default_timezone_set('America/Santiago');
file_put_contents("log_crear_pago.txt", date('Y-m-d H:i:s') . " | archivo ejecutado\n", FILE_APPEND);

MercadoPago\SDK::setAccessToken('APP_USR-2189792743192324-033112-7e3b141e5f7f42fd3980dbd5306cec96-577242728');
MercadoPago\SDK::setIntegratorId('dev_12345678');

$nombre = $_POST['nombre'] ?? '';
$email = $_POST['email'] ?? '';
$total = (int) ($_POST['total'] ?? 0);
file_put_contents("log_crear_pago.txt", date('Y-m-d H:i:s') . " | TOTAL recibido: $total\n", FILE_APPEND);
$carrito = json_decode($_POST['json'] ?? '[]', true);
$descuento_aplicado = (int) ($_POST['descuento_aplicado'] ?? 0);

// Armar la descripción
$descripcion = "Pedido de $nombre - Empanadas";
foreach ($carrito as $item) {
  $descripcion .= " | {$item['cantidad']}x {$item['nombre']}";
}

// Crear preferencia
$preference = new MercadoPago\Preference();
$items = [];

foreach ($carrito as $c) {
    $item = new MercadoPago\Item();
    $item->title = $c['nombre'];
    $item->quantity = (int) $c['cantidad'];
    $item->unit_price = (float) $c['precio'];
    $item->currency_id = 'CLP';
    $items[] = $item;
}

$preference->items = $items;

// Datos del comprador
$payer = new MercadoPago\Payer();
$payer->name = $nombre;
$payer->email = $email;
$preference->payer = $payer;

// Opcional: Puedes agregar más datos personalizados en `metadata`
$preference->metadata = [
  'nombre' => $nombre,
  'email' => $email,
  'detalle' => $descripcion,
  'carrito' => $carrito,
  'descuento_aplicado' => $descuento_aplicado
];

// Redirecciones
$preference->back_urls = [
    "success" => "https://3833-168-232-165-4.ngrok-free.app/Pedidos_Saas/admin/retorno_pago.php",
    "failure" => "https://3833-168-232-165-4.ngrok-free.app/Pedidos_Saas/admin/retorno_pago.php",
    "pending" => "https://3833-168-232-165-4.ngrok-free.app/Pedidos_Saas/admin/retorno_pago.php"
];
$preference->notification_url = "https://3833-168-232-165-4.ngrok-free.app/Pedidos_Saas/admin/notificacion_mp.php";

if ($total <= 0) {
    echo json_encode(['error' => 'Total inválido']);
    exit;
}

try {
    $preference->save();
    file_put_contents("log_crear_pago.txt", date('Y-m-d H:i:s') . " | PREFERENCIA: " . print_r($preference, true) . "\n", FILE_APPEND);
} catch (Exception $e) {
    file_put_contents("log_crear_pago.txt", date('Y-m-d H:i:s') . " | ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
    echo json_encode(['error' => 'Error al crear preferencia: ' . $e->getMessage()]);
    exit;
}

// Devolver el init_point para redireccionar desde JS
if (!isset($preference->init_point)) {
    echo json_encode(['error' => 'No se generó init_point']);
    exit;
}

echo json_encode([
    'test' => true,
    'init_point' => $preference->sandbox_init_point ?? null
]);
exit;