<?php
require_once '../config/config.php';

if (!isset($_GET['id'])) {
  die("Pedido no especificado.");
}

$id = intval($_GET['id']);
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Obtener datos del pedido
$stmt = $conn->prepare("SELECT id, negocio_id, cliente_nombre, cliente_email, telefono, cliente_direccion, fecha, fecha_hora_entrega, total, estado FROM pedidos WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$pedido = $stmt->get_result()->fetch_assoc();
if (!isset($pedido['negocio_id'])) {
  die("FALTA NEGOCIO_ID EN EL PEDIDO");
}
if (!$pedido) die("Pedido no encontrado.");

error_log("Estado actual del pedido: " . $pedido['estado']);
if (true) {
  // Cambiar estado a confirmado
  $conn->query("UPDATE pedidos SET estado = 'confirmado' WHERE id = $id");

  // Obtener detalle del pedido para movimientos
  $stmt_items_reg = $conn->prepare("SELECT producto_id, cantidad FROM pedido_items WHERE pedido_id = ?");
  $stmt_items_reg->bind_param("i", $id);
  $stmt_items_reg->execute();
  $detalles = $stmt_items_reg->get_result();

  // Registrar movimientos de inventario con stock_anterior y stock_actual
  while ($fila = $detalles->fetch_assoc()) {
    $producto_id = (int) $fila['producto_id'];
    $cantidad = (int) $fila['cantidad'];
    $motivo = "Venta confirmada (Pedido #$id)";

    // Obtener stock actual antes de movimiento
    $stock_result = $conn->query("SELECT stock FROM productos WHERE id = $producto_id");
    $stock_anterior = (int) $stock_result->fetch_assoc()['stock'];
    $stock_actual = $stock_anterior - $cantidad;

    $mov_stmt = $conn->prepare("INSERT INTO inventario_movimientos 
      (producto_id, negocio_id, tipo_movimiento, cantidad, motivo, usuario_id, stock_anterior, stock_actual) 
      VALUES (?, ?, 'venta', ?, ?, NULL, ?, ?)");

    $mov_stmt->bind_param("iiisii", $producto_id, $pedido['negocio_id'], $cantidad, $motivo, $stock_anterior, $stock_actual);

    if (!$mov_stmt->execute()) {
      error_log("Error en execute: " . $mov_stmt->error);
    }

    if ($mov_stmt->affected_rows > 0) {
      error_log("Movimiento registrado: producto $producto_id, stock de $stock_anterior a $stock_actual.");
    } else {
      error_log("ERROR: No se registró movimiento para producto $producto_id.");
    }

    $conn->query("UPDATE productos SET stock = $stock_actual WHERE id = $producto_id");
  }
  if (!function_exists('enviarCorreoEstado')) {
    error_log("ERROR: La función enviarCorreoEstado no está definida.");
  } else {
    error_log("Intentando enviar correo a " . $pedido['cliente_email']);
  }

  enviarCorreoEstado(
    $pedido['cliente_email'],
    $pedido['cliente_nombre'],
    'preparando',
    $id,
    $_SESSION['logo_url'] ?? 'logoN1.png'
  );
  error_log("Correo de estado enviado.");
}

// Obtener los ítems del pedido con nombre del producto
$query = "
  SELECT pi.cantidad, pi.precio_unitario, p.nombre AS producto_nombre
  FROM pedido_items pi
  JOIN productos p ON pi.producto_id = p.id
  WHERE pi.pedido_id = ?
";
$stmt_items = $conn->prepare($query);
$stmt_items->bind_param("i", $id);
$stmt_items->execute();
$items = $stmt_items->get_result();
?>
<!DOCTYPE html>
<html lang="es">

<head>
  <meta charset="UTF-8">
  <title>Ticket Pedido #<?php echo $pedido['id']; ?></title>
  <style>
    <?php if (strtoupper(trim($pedido['cliente_direccion'])) !== 'RETIRO TIENDA'): ?>body::before {
      content: "";
      position: absolute;
      top: 60px;
      right: 10px;
      width: 60px;
      height: 60px;
      background-image: url('../images/delivery_bw.png');
      background-repeat: no-repeat;
      background-size: contain;
      /*opacity: 0.08;*/
      z-index: 0;
    }

    <?php endif; ?>body {
      font-family: monospace;
      font-size: 12px;
      padding: 10px;
      max-width: 300px;
      margin: auto;
      position: relative;
      z-index: 1;
    }

    /* Resto de tu CSS sigue igual... */
    .center {
      text-align: center;
    }

    .bold {
      font-weight: bold;
    }

    .item {
      display: flex;
      justify-content: space-between;
      margin: 4px 0;
    }

    .separator {
      border-top: 1px dashed #000;
      margin: 6px 0;
    }

    .footer {
      margin-top: 10px;
      text-align: center;
    }

    @media print {
      body {
        margin: 0;
      }

      button {
        display: none;
      }
    }
  </style>
</head>

<body onload="window.print()">
  <div class="center">
    <img src="../images/logo_bw.png" alt="Logo" style="max-width: 100%; height: auto; margin-bottom: 5px;">
  </div>
  <div class="center bold">Delicias Dulces y Saladas</div>
  <div class="center">Pedido #<?php echo $pedido['id']; ?></div>
  <div class="separator"></div>

  <div><span class="bold">Cliente:</span> <?php echo htmlspecialchars($pedido['cliente_nombre']); ?></div>
  <div><span class="bold">Tel:</span> <?php echo htmlspecialchars($pedido['telefono']); ?></div>

  <div><span class="bold">Fecha:</span> <?php echo date('d-m-Y H:i', strtotime($pedido['fecha'])); ?></div>
  <br>
  <?php if (strtoupper(trim($pedido['cliente_direccion'])) === 'RETIRO TIENDA'): ?>
    <div><span class="bold">RETIRO EN TIENDA</span></div>
    <?php if (!empty($pedido['fecha_hora_entrega'])): ?>
      <div><span class="bold">Entrega:</span> <?php echo date('d-m-Y H:i', strtotime($pedido['fecha_hora_entrega'])); ?></div>
    <?php endif; ?>
  <?php else: ?>
    <div><span class="bold">DELIVERY</span></div>
    <div> <?php echo htmlspecialchars($pedido['cliente_direccion']); ?></div>
    <?php if (!empty($pedido['fecha_hora_entrega'])): ?>
      <div><span class="bold">Programado para :</span> <?php echo date('d-m-Y H:i', strtotime($pedido['fecha_hora_entrega'])); ?></div>
    <?php endif; ?>
  <?php endif; ?>




  <div class="separator"></div>
  <div class="bold">Detalle:</div>

  <?php while ($item = $items->fetch_assoc()):
    $subtotal = $item['cantidad'] * $item['precio_unitario'];
  ?>
    <div class="item">
      <span><?php echo $item['cantidad'] . ' x ' . $item['producto_nombre']; ?></span>
      <span>$<?php echo number_format($subtotal, 0, ',', '.'); ?></span>
    </div>
  <?php endwhile; ?>

  <div class="separator"></div>
  <div class="item bold">
    <span>TOTAL:</span>
    <span>$<?php echo number_format($pedido['total'], 0, ',', '.'); ?></span>
  </div>

  <div class="separator"></div>
  <div class="footer">
    ¡Gracias por su compra!
  </div>

</body>

</html>