<?php
session_start();
require_once '../config/config.php';
require_once '../mailer/deliciasdulcesysaladas.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Obtener logo de la sesión (opcional)
$logoUrl = $_SESSION['logo_url'] ?? 'logoN1.png';

// Obtener todos los pedidos pendientes
//$pedidos_result = $conn->query("SELECT * FROM pedidos WHERE estado = 'pendiente' ORDER BY fecha ASC");
$pedidos_result = $conn->query("SELECT
	p.id as IdCliente,
	p.negocio_id as IdNegocio,
	p.cliente_nombre as NomCliente,
	p.cliente_email as MaiCliente,
	p.cliente_direccion as DirCliente,
	p.total as TotPedido,
	p.estado as EstPedido,
	p.fecha as FecPedido,
	p.delivery_monto as MonDelivery,
	p.distancia_km as KmDelivery,
	p.comentario_direccion as ComDireccion,
	p.telefono as TelCliente,
	n.nombre as NomEmpresa,
	n.descripcion as DesEmpresa,
	n.logo_url as LogEmpresa,
	n.email as  MaiEmpresa,
	n.telefono as TelEmpresa,
	n.direccion as DirEmpresa,
	n.horario_apertura as HaEmpresa,
	n.horario_cierre as HcEmpresa,
	n.activo as EstEmpresa
FROM
	pedidos AS p
	INNER JOIN negocios AS n ON n.id = p.negocio_id
  WHERE p.estado = 'pendiente' 
ORDER BY
	fecha ASC;");

if ($pedidos_result->num_rows === 0) {
  die("No hay pedidos pendientes.");
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
  <meta charset="UTF-8">
  <title>Imprimir Pedidos Pendientes</title>
  <style>
    body {
      font-family: monospace;
      font-size: 12px;
      padding: 10px;
      max-width: 300px;
      margin: auto;
    }

    .ticket {
      page-break-after: always;
      break-after: page;
      min-height: 280px;
      padding-bottom: 10px;
      margin-bottom: 30px;
    }

    .center {
      text-align: center;
    }

    .bold {
      font-weight: bold;
    }

    .item {
      display: flex;
      justify-content: space-between;
      margin: 4px 0;
    }

    .separator {
      border-top: 1px dashed #000;
      margin: 6px 0;
    }

    .footer {
      margin-top: 10px;
      text-align: center;
    }

    button {
      display: block;
      width: 100%;
      padding: 10px;
      font-size: 14px;
      margin-top: 20px;
    }

    @media print {
      body {
        margin: 0;
      }

      button {
        display: none !important;
      }

      .ticket {
        page-break-after: always;
        break-after: page;
      }
    }
  </style>
</head>

<body>

  <?php while ($pedido = $pedidos_result->fetch_assoc()):
    ob_start(); // Iniciar el buffer
    $id = $pedido['IdCliente'];
    $stmt_items = $conn->prepare("
    SELECT pi.cantidad, pi.precio_unitario, p.nombre AS producto_nombre
    FROM pedido_items pi
    JOIN productos p ON pi.producto_id = p.id
    WHERE pi.pedido_id = ?
  ");
    $stmt_items->bind_param("i", $id);
    $stmt_items->execute();
    $items = $stmt_items->get_result();
  ?>
    <div class="ticket">
      <div class="center bold"><?php echo htmlspecialchars($pedido['NomEmpresa']); ?></div>
      <div class="center">Pedido #<?php echo $pedido['IdCliente']; ?></div>
      <div class="separator"></div>

      <div><span class="bold">Cliente:</span> <?php echo htmlspecialchars($pedido['NomCliente']); ?></div>
      <div><span class="bold">Tel:</span> <?php echo htmlspecialchars($pedido['TelCliente']); ?></div>
      <div><span class="bold">Dir:</span> <?php echo htmlspecialchars($pedido['DirCliente']); ?></div>
      <div><span class="bold">Fecha:</span> <?php echo date('d-m-Y H:i', strtotime($pedido['FecPedido'])); ?></div>

      <div class="separator"></div>
      <div class="bold">Detalle:</div>

      <?php while ($item = $items->fetch_assoc()):
        $subtotal = $item['cantidad'] * $item['precio_unitario'];
      ?>
        <div class="item">
          <span><?php echo $item['cantidad'] . ' x ' . $item['producto_nombre']; ?></span>
          <span>$<?php echo number_format($subtotal, 0, ',', '.'); ?></span>
        </div>
      <?php endwhile; ?>

      <div class="separator"></div>
      <div class="item bold">
        <span>TOTAL:</span>
        <span>$<?php echo number_format($pedido['TotPedido'], 0, ',', '.'); ?></span>
      </div>

      <div class="separator"></div>
      <div class="footer">
        ¡Gracias por su compra!
      </div>
    </div>
  <?php
    // Imprimir y limpiar el buffer
    echo ob_get_clean();
    ob_flush();
    flush();

    // Actualizar estado a "preparando"
    $conn->query("UPDATE pedidos SET estado = 'confirmado' WHERE id = $id");

    // Registrar movimiento de inventario por cada producto del pedido
    $stmt_detalle = $conn->prepare("
        SELECT producto_id, cantidad
        FROM pedido_items
        WHERE pedido_id = ?
    ");
    $stmt_detalle->bind_param("i", $id);
    $stmt_detalle->execute();
    $detalle_result = $stmt_detalle->get_result();

    while ($detalle = $detalle_result->fetch_assoc()) {
      $producto_id = (int) $detalle['producto_id'];
      $cantidad = (int) $detalle['cantidad'];
      $motivo = "Venta confirmada (Pedido #$id)";

      $stock_q = $conn->query("SELECT stock FROM productos WHERE id = $producto_id");
      $stock_anterior = (int) $stock_q->fetch_assoc()['stock'];
      $stock_actual = $stock_anterior - $cantidad;

      $mov_stmt = $conn->prepare("INSERT INTO inventario_movimientos 
        (producto_id, negocio_id, tipo_movimiento, cantidad, motivo, usuario_id, stock_anterior, stock_actual) 
        VALUES (?, ?, 'venta', ?, ?, NULL, ?, ?)");
      $mov_stmt->bind_param("iiisii", $producto_id, $pedido['IdNegocio'], $cantidad, $motivo, $stock_anterior, $stock_actual);
      $mov_stmt->execute();

      $conn->query("UPDATE productos SET stock = $stock_actual WHERE id = $producto_id");
    }

    // Enviar correo al cliente con nuevo estado
    enviarCorreoEstado(
      $pedido['MaiCliente'],
      $pedido['NomCliente'],
      'confirmado',
      $id,
      $logoUrl
    );

  endwhile;
  $conn->close();
  ?>

  <button onclick="window.print()">🖨️ Imprimir Todos</button>
</body>

</html>