<?php
require '../../vendor/autoload.php';
include("api/conn.php"); // Asegúrate de que este archivo conecta a tu BD

MercadoPago\SDK::setAccessToken('APP_USR-2189792743192324-033112-7e3b141e5f7f42fd3980dbd5306cec96-577242728');

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['data']['id'])) {
  http_response_code(400);
  echo 'Missing payment ID';
  exit;
}

$payment_id = $data['data']['id'];
$payment = MercadoPago\Payment::find_by_id($payment_id);

if ($payment->status === 'approved') {
  $meta = $payment->metadata;

  $nombre = $conn->real_escape_string($meta->nombre ?? '');
  $email = $conn->real_escape_string($meta->email ?? '');
  $comuna = $conn->real_escape_string($meta->comuna ?? '');
  $direccion_calle = $conn->real_escape_string($meta->direccion ?? '');
  $numero = $conn->real_escape_string($meta->numero ?? '');
  $direccion = "$direccion_calle #$numero, $comuna";
  $carrito = $meta->carrito ?? [];
  $total = (int)$payment->transaction_amount;
  $delivery_monto = (int)($meta->delivery_monto ?? 0);
  $distancia_km = (float)($meta->distancia_km ?? 0);
  $descuento_aplicado = (int)($meta->descuento_aplicado ?? 0);
  $estado = 'PagadoMP';
  $fecha = date('Y-m-d H:i:s');
  $negocio_id = 1;

  // Insertar pedido principal
  $stmt = $conn->prepare("INSERT INTO pedidos (negocio_id, cliente_nombre, cliente_telefono, cliente_direccion, total, estado, fecha, delivery_monto, distancia_km) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
  $stmt->bind_param("isssissid", $negocio_id, $nombre, $email, $direccion, $total, $estado, $fecha, $delivery_monto, $distancia_km);

  if ($stmt->execute()) {
    $pedido_id = $stmt->insert_id;

    // Insertar productos del pedido
    $item_stmt = $conn->prepare("INSERT INTO pedido_items (pedido_id, producto_id, cantidad, precio_unitario) VALUES (?, ?, ?, ?)");
    foreach ($carrito as $item) {
      $producto_id = (int) $item->id;
      $cantidad = (int) $item->cantidad;
      $precio_unitario = (int) $item->precio;
      $item_stmt->bind_param("iiii", $pedido_id, $producto_id, $cantidad, $precio_unitario);
      $item_stmt->execute();
    }

    // Registrar descuento si existe
    if ($descuento_aplicado > 0) {
      $stmt_desc = $conn->prepare("INSERT INTO RegistroDescuentos (negocio_id, id_pedido, monto_descuento) VALUES (?, ?, ?)");
      $stmt_desc->bind_param("iii", $negocio_id, $pedido_id, $descuento_aplicado);
      $stmt_desc->execute();
    }
  }
}

http_response_code(200);
echo 'OK';
