<?php
$status = $_GET['status'] ?? 'undefined';
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Resultado del Pago</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 2rem; text-align: center; }
    .box { background: white; padding: 2rem; border-radius: 10px; max-width: 500px; margin: auto; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    h1 { color: #4caf50; }
    .error { color: #f44336; }
  </style>
</head>
<body>
  <div class="box">
    <?php if ($status === 'approved'): ?>
      <h1>✅ ¡Pago realizado con éxito!</h1>
      <p>Gracias por tu compra. Tu pedido ha sido confirmado.</p>
    <?php elseif ($status === 'pending'): ?>
      <h1>⌛ Pago pendiente</h1>
      <p>Estamos esperando la confirmación del pago.</p>
    <?php else: ?>
      <h1 class="error">❌ Pago no realizado</h1>
      <p>El pago fue cancelado o ocurrió un error. Intenta nuevamente.</p>
    <?php endif; ?>
    <br>
    <a href="checkout.php" style="text-decoration: none; background: #2196f3; color: white; padding: 10px 20px; border-radius: 5px;">Volver al inicio</a>
  </div>
</body>
</html>