<?php
session_start();

// Verificar si el usuario está logueado
if (!isset($_SESSION['usuario'])) {
    header("Location: ../login.php");
    exit();
}

require_once '../config/config.php';

header('Content-Type: application/json');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    echo json_encode(['valido' => false, 'error' => 'Error de conexión']);
    exit;
}

$codigo = $_POST['codigo'] ?? '';
$fecha_actual = date('Y-m-d');

$sql = "SELECT * FROM Descuentos 
        WHERE codigo = ? 
        AND fecha_inicio <= ? 
        AND fecha_fin >= ? 
        AND activo = 1 
        LIMIT 1";

$stmt = $conn->prepare($sql);
$stmt->bind_param("sss", $codigo, $fecha_actual, $fecha_actual);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode([
        'valido' => true,
        'descuento_porcentaje' => $row['descuento_porcentaje'],
        'descuento_monto' => $row['descuento_monto'],
        'categoria' => $row['categoria'],
        'producto_id' => $row['producto_id']
    ]);
} else {
    echo json_encode(['valido' => false]);
}

$stmt->close();
$conn->close();
