<?php
require_once '../config/config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Recibir datos del formulario
$id = $_POST['id'] ?? '';
$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'] ?? '';
$logo_url = $_POST['logo_url'] ?? '';
$email = $_POST['email'] ?? '';
$telefono = $_POST['telefono'] ?? '';
$direccion = $_POST['direccion'] ?? '';
$horario_apertura = $_POST['horario_apertura'] ?? null;
$horario_cierre = $_POST['horario_cierre'] ?? null;
$activo = isset($_POST['activo']) ? 1 : 0;

// Validación básica
if (empty($nombre)) {
  die("El nombre del negocio es obligatorio.");
}

if ($id) {
  // Actualizar
  $stmt = $conn->prepare("UPDATE negocios SET nombre = ?, descripcion = ?, logo_url = ?, email = ?, telefono = ?, direccion = ?, horario_apertura = ?, horario_cierre = ?, activo = ? WHERE id = ?");
  $stmt->bind_param("ssssssssii", $nombre, $descripcion, $logo_url, $email, $telefono, $direccion, $horario_apertura, $horario_cierre, $activo, $id);
} else {
  // Insertar nuevo
  $stmt = $conn->prepare("INSERT INTO negocios (nombre, descripcion, logo_url, email, telefono, direccion, horario_apertura, horario_cierre, activo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
  $stmt->bind_param("ssssssssi", $nombre, $descripcion, $logo_url, $email, $telefono, $direccion, $horario_apertura, $horario_cierre, $activo);
}

if ($stmt->execute()) {
    header("Location: panel.php?view=negocios&guardado=1");
  exit;
} else {
  echo "Error al guardar el negocio: " . $stmt->error;
}

