<?php
// guardar_pack.php
require 'config.php'; // Asegúrate de incluir la configuración con DB_HOST, DB_USER, DB_PASS, DB_NAME

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Recoger y sanitizar datos del formulario
$nombre       = $conn->real_escape_string($_POST['nombre']);
$descripcion  = $conn->real_escape_string($_POST['descripcion']);
$precio       = floatval($_POST['precio']);
$fecha_inicio = !empty($_POST['fecha_inicio']) ? $_POST['fecha_inicio'] : null;
$fecha_fin    = !empty($_POST['fecha_fin']) ? $_POST['fecha_fin'] : null;

// Procesar la imagen, si se cargó
$imagen_url = "";
if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] === 0) {
    $target_dir  = "images/productos/";
    $filename    = basename($_FILES["imagen"]["name"]);
    $target_file = $target_dir . $filename;
    
    // Puedes agregar validación de tipo y tamaño de archivo aquí
    if (move_uploaded_file($_FILES["imagen"]["tmp_name"], $target_file)) {
        $imagen_url = $conn->real_escape_string($filename);
    }
}

// Insertar el producto tipo PACK en la tabla `productos`
$query = "INSERT INTO productos (nombre, descripcion, precio, tipo_producto, fecha_inicio, fecha_fin, imagen_url)
          VALUES (
            '$nombre',
            '$descripcion',
            $precio,
            'pack',
            " . ($fecha_inicio ? "'$fecha_inicio'" : "NULL") . ",
            " . ($fecha_fin ? "'$fecha_fin'" : "NULL") . ",
            '$imagen_url'
          )";

if ($conn->query($query)) {
    // Obtener el ID del pack recién insertado
    $pack_id = $conn->insert_id;

    // Procesar los productos seleccionados que componen el pack
    if (isset($_POST['productos_ids']) && is_array($_POST['productos_ids'])) {
        foreach ($_POST['productos_ids'] as $prod_id) {
            $prod_id = intval($prod_id);
            // Verificar que se haya ingresado una cantidad válida
            $cantidad = isset($_POST['cantidad_' . $prod_id]) ? intval($_POST['cantidad_' . $prod_id]) : 1;
            
            $detalle_query = "INSERT INTO productos_pack_detalle (pack_id, producto_id, cantidad)
                              VALUES ($pack_id, $prod_id, $cantidad)";
            $conn->query($detalle_query);
        }
    }
    // Redireccionar a la vista de productos con mensaje de éxito
    header("Location: panel.php?view=productos&guardado=pack");
    exit;
} else {
    echo "Error al guardar el pack: " . $conn->error;
}

$conn->close();
?>

<div id="contenedor_cantidades" style="margin-top: 15px;"></div>
<script>
    document.addEventListener('DOMContentLoaded', function () {
      $('#productos_ids').select2({
        placeholder: "Selecciona productos",
        allowClear: true
      });

      $('#productos_ids').on('change', function () {
        const selected = $(this).val();
        const container = document.getElementById('contenedor_cantidades');
        container.innerHTML = '';

        if (selected) {
          selected.forEach(function (id) {
            const div = document.createElement('div');
            div.style.marginBottom = '10px';
            div.innerHTML = `
              <label>Cantidad para producto ID ${id}:</label>
              <input type="number" name="cantidad_${id}" value="1" min="1" style="width: 100px;">
            `;
            container.appendChild(div);
          });
        }
      });
    });
</script>
