<?php
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$negocio_id = $_SESSION['negocio_id'] ?? 0;

$modo = "Crear";
$producto = [
  'id' => '',
  'nombre' => '',
  'descripcion' => '',
  'imagen_url' => '',
  'precio' => '',
  'stock' => '',
  'categoria' => '',
  'categoria1' => '',
  'categoria2' => '',
  'categoria3' => '',
  'activo' => 1
];

if (isset($_GET['id'])) {
  $id = intval($_GET['id']);
  $stmt = $conn->prepare("SELECT * FROM productos WHERE id = ? AND negocio_id = ?");
  $stmt->bind_param("ii", $id, $negocio_id);
  $stmt->execute();
  $res = $stmt->get_result();
  if ($res->num_rows > 0) {
    $producto = $res->fetch_assoc();
    $modo = "Editar";
  }
}
?>
<!-- Quill CSS -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<!-- Quill JS -->
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>

<div class="container py-4">
  <div class="card border-0 rounded-4">
    <div class="card-body">
      <h4><?php echo $modo; ?> Producto</h4>

      <form action="panel.php?view=guardar_producto" method="POST" enctype="multipart/form-data" class="form-container">

        <input type="hidden" name="id" value="<?php echo $producto['id']; ?>">
        <input type="hidden" name="negocio_id" value="<?php echo $negocio_id; ?>">

        <!-- Nombre, Descripción y Precio en dos columnas -->
        <div class="row mb-3">
          <div class="col-md-6">
            <label for="nombre">Nombre:</label>
            <input type="text" id="nombre" name="nombre" class="form-control" value="<?php echo htmlspecialchars($producto['nombre']); ?>" required>
          </div>
        </div>

        <!-- Descripcion -->
        <div class="mb-3">
          <label for="descripcion">Descripción:</label>
          <div id="editor" style="height: 200px;"><?php echo $producto['descripcion']; ?></div>
          <input type="hidden" name="descripcion" id="descripcion">
        </div>

        <!-- Precio y Stock en dos columnas -->
        <div class="row mb-3">
          <div class="col-md-6">
            <label for="precio">Precio:</label>
            <input type="number" id="precio" name="precio" class="form-control" value="<?php echo $producto['precio']; ?>" step="0.01" required>
          </div>
          <?php if ($modo === 'Crear'): ?>
            <div class="col-md-6">
              <label for="stock_inicial">Stock inicial:</label>
              <input type="number" id="stock_inicial" name="stock_inicial" class="form-control" value="0" min="0">
            </div>
          <?php endif; ?>
          <div class="col-md-6">
            <label for="stock">Stock actual:</label>
            <input type="number" id="stock" name="stock" class="form-control" value="<?php echo $producto['stock']; ?>" readonly>
            <small class="text-muted">El stock se actualiza mediante movimientos de inventario.</small>
          </div>
        </div>

        <!-- Categoría Principal y Categorías adicionales en dos columnas -->
        <div class="row mb-3">
          <div class="col-md-6">
            <label for="categoria">Categoría principal:</label>
            <input type="text" id="categoria" name="categoria" class="form-control" value="<?php echo $producto['categoria']; ?>">
          </div>

          <div class="col-md-6">
            <label for="categoria1">Categoría 1:</label>
            <input type="text" id="categoria1" name="categoria1" class="form-control" value="<?php echo $producto['categoria1']; ?>">
          </div>
        </div>

        <!-- Categoría 2 y 3 en una fila -->
        <div class="row mb-3">
          <div class="col-md-6">
            <label for="categoria2">Categoría 2:</label>
            <input type="text" id="categoria2" name="categoria2" class="form-control" value="<?php echo $producto['categoria2']; ?>">
          </div>

          <div class="col-md-6">
            <label for="categoria3">Categoría 3:</label>
            <input type="text" id="categoria3" name="categoria3" class="form-control" value="<?php echo $producto['categoria3']; ?>">
          </div>
        </div>

        <!-- Imagen en una fila sola -->
        <div class="mb-3">
          <label for="imagen">Imagen:</label>
          <input type="file" name="imagen" id="imagen" class="form-control">
          <?php if ($producto['imagen_url']): ?>
            <div style="margin-top: 10px;">
              <img src="<?php echo $producto['imagen_url']; ?>" width="80" alt="Imagen del producto">
            </div>
          <?php endif; ?>
        </div>

        <!-- Checkbox (Activo) en una fila sola -->
        <div class="mb-3 form-check">
          <input type="checkbox" id="activo" name="activo" value="1" class="form-check-input" <?php echo $producto['activo'] ? 'checked' : ''; ?>>
          <label class="form-check-label" for="activo">Producto Activo</label>
        </div>

        <!-- Campos adicionales -->
        <div class="row mb-3">
          <div class="col-md-6">
            <label for="tipo_producto">Tipo de producto:</label>
            <select id="tipo_producto" name="tipo_producto" class="form-select" onchange="mostrarSeccionesPorTipo()">
              <option value="Normal" <?php echo ($producto['tipo_producto'] ?? '') === 'Normal' ? 'selected' : ''; ?>>Normal</option>
              <option value="Pack" <?php echo ($producto['tipo_producto'] ?? '') === 'Pack' ? 'selected' : ''; ?>>Pack</option>
              <option value="Combo" <?php echo ($producto['tipo_producto'] ?? '') === 'Combo' ? 'selected' : ''; ?>>Combo</option>
              <option value="Servicio" <?php echo ($producto['tipo_producto'] ?? '') === 'Servicio' ? 'selected' : ''; ?>>Servicio</option>
            </select>
          </div>
          <div class="col-md-6 seccion-normal">
            <label for="sobreventa">Permitir sobreventa:</label>
            <select id="sobreventa" name="sobreventa" class="form-select">
              <option value="0" <?php echo ($producto['sobreventa'] ?? 0) == 0 ? 'selected' : ''; ?>>No</option>
              <option value="1" <?php echo ($producto['sobreventa'] ?? 0) == 1 ? 'selected' : ''; ?>>Sí</option>
            </select>
          </div>
        </div>

        <div class="row mb-3 seccion-normal">
          <div class="col-md-6">
            <label for="Apedido">A pedido:</label>
            <select id="Apedido" name="Apedido" class="form-select" onchange="toggleHoras(this.value)">
              <option value="0" <?php echo ($producto['Apedido'] ?? 0) == 0 ? 'selected' : ''; ?>>No</option>
              <option value="1" <?php echo ($producto['Apedido'] ?? 0) == 1 ? 'selected' : ''; ?>>Sí</option>
            </select>
          </div>
          <div class="col-md-6">
            <label for="hrs_produccion">Horas de Producción:</label>
            <input type="text" id="hrs_produccion" name="hrs_produccion" class="form-control"
              inputmode="numeric" pattern="[0-9]{1,2}" maxlength="2"
              value="<?php echo $producto['hrs_produccion'] ?? ''; ?>"
              oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 2);">
          </div>
        </div>

        <div class="row mb-3">
          <div class="col-md-6">
            <label for="unidad_medida">Unidad de medida:</label>
            <input type="text" id="unidad_medida" name="unidad_medida" class="form-control" value="<?php echo $producto['unidad_medida'] ?? ''; ?>">
          </div>
          <div class="col-md-6">
            <label for="stock_minimo">Stock mínimo:</label>
            <input type="number" id="stock_minimo" name="stock_minimo" class="form-control" value="<?php echo $producto['stock_minimo'] ?? 0; ?>">
          </div>
        </div>

        <div class="row mb-3">
          <div class="col-md-6">
            <label for="sku">SKU:</label>
            <input type="text" id="sku" name="sku" class="form-control" value="<?php echo $producto['sku'] ?? ''; ?>">
          </div>
          <div class="col-md-6">
            <label for="codigo_barras">Código de barras:</label>
            <input type="text" id="codigo_barras" name="codigo_barras" class="form-control" value="<?php echo $producto['codigo_barras'] ?? ''; ?>">
          </div>
        </div>

        <div class="row mb-3">
          <div class="col-md-6">
            <label for="precio_oferta">Precio oferta:</label>
            <input type="number" id="precio_oferta" name="precio_oferta" class="form-control" step="0.01" value="<?php echo $producto['precio_oferta'] ?? ''; ?>">
          </div>
          <div class="col-md-6">
            <label for="ubicacion">Ubicación en bodega:</label>
            <input type="text" id="ubicacion" name="ubicacion" class="form-control" value="<?php echo $producto['ubicacion'] ?? ''; ?>">
          </div>
        </div>

        <div class="mb-3">
          <label for="notas">Notas internas:</label>
          <textarea id="notas" name="notas" class="form-control"><?php echo $producto['notas'] ?? ''; ?></textarea>
        </div>

        <!-- Botones de acción -->
        <div class="text-end mt-4">
          <a href="panel.php?view=productos" class="btn btn-outline-secondary">Cancelar</a>
          <button type="submit" class="btn btn-primary">Guardar</button>
        </div>

      </form>
    </div>
  </div>
</div>

<script>
  var quill = new Quill('#editor', {
    theme: 'snow',
    placeholder: 'Escribe la descripción del producto...',
    modules: {
      toolbar: [
        [{
          'header': [1, 2, false]
        }],
        ['bold', 'italic'],
        [{
          'align': []
        }],
        [{
          'list': 'ordered'
        }, {
          'list': 'bullet'
        }],
        ['clean']
      ]
    }
  });

  // Guardar contenido HTML al enviar
  document.querySelector('form').addEventListener('submit', function() {
    document.querySelector('#descripcion').value = quill.root.innerHTML;
  });
</script>
<script>
  function toggleHoras(valor) {
    const hrs = document.getElementById('hrs_produccion');
    if (valor == "1") {
      hrs.disabled = false;
    } else {
      hrs.value = '';
      hrs.disabled = true;
    }
  }

  // Ejecutar al cargar por si ya viene como "Sí"
  document.addEventListener("DOMContentLoaded", function() {
    toggleHoras(document.getElementById('Apedido').value);
  });
</script>
<script>
  function mostrarSeccionesPorTipo() {
    const tipo = document.getElementById('tipo_producto').value;
    document.querySelectorAll('.seccion-normal').forEach(el => {
      el.style.display = (tipo === 'Normal' || tipo === 'Servicio') ? '' : 'none';
    });
  }

  document.addEventListener('DOMContentLoaded', function() {
    mostrarSeccionesPorTipo();
  });
</script>