<?php
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$productos = $conn->query("SELECT * FROM productos WHERE tipo_producto = 'normal' and negocio_id=1 ORDER BY nombre ASC");
?>

<h4>Crear nuevo PACK o COMBO</h4>

<form action="panel.php?view=guardar_pack" method="POST" enctype="multipart/form-data">
  <div style="margin-bottom: 15px;">
    <label>Nombre del Pack:</label>
    <input type="text" name="nombre" required style="width: 100%;">
  </div>

  <div style="margin-bottom: 15px;">
    <label>Descripción:</label>
    <textarea name="descripcion" rows="3" style="width: 100%;"></textarea>
  </div>

  <div style="margin-bottom: 15px;">
    <label>Imagen:</label>
    <input type="file" name="imagen" style="width: 100%;">
  </div>

  <div style="display: flex; gap: 20px; margin-bottom: 15px;">
    <div style="flex: 1;">
      <label>Precio del Pack:</label>
      <input type="number" step="0.01" name="precio" required style="width: 100%;">
    </div>
    <div style="flex: 1;">
      <label>Validez Desde:</label>
      <input type="date" name="fecha_inicio" style="width: 100%;">
    </div>
    <div style="flex: 1;">
      <label>Hasta:</label>
      <input type="date" name="fecha_fin" style="width: 100%;">
    </div>
  </div>

  <div>
    <label>Selecciona los productos que componen el Pack:</label><br>
    <select name="productos_ids[]" id="productos_ids" multiple="multiple" style="width: 100%;">
      <?php while ($prod = $productos->fetch_assoc()): ?>
        <option value="<?= $prod['id'] ?>"><?= htmlspecialchars($prod['nombre']) ?></option>
      <?php endwhile; ?>
    </select>
  </div>

  <button type="submit">Guardar Pack</button>
</form>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    $('#productos_ids').select2({
      placeholder: "Selecciona productos",
      allowClear: true
    });
  });
</script>
