<?php
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$negocio_id = $_SESSION['negocio_id'] ?? 0;

$result = $conn->query("SELECT * FROM productos WHERE negocio_id = $negocio_id ORDER BY id DESC");
?>

<div class="container-fluid">
  <?php if (isset($_GET['guardado'])): ?>
    <div class="alert alert-success">
      ✅ Producto guardado correctamente.
    </div>
  <?php endif; ?>

  <?php if (isset($_GET['eliminado'])): ?>
    <div class="alert alert-success">
      ✅ Producto Eliminado correctamente.
    </div>
  <?php endif; ?>
  <style>
    td.descripcion-cell {
      max-width: 180px;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      font-size: 0.9rem;
      color: #555;
    }
  </style>
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mt-2 mb-3">
    <h4 class="mb-0 fw-semibold">
      <i class="fas fa-box-open me-2 text-primary"></i>Listado de Productos
    </h4>
    <div class="d-flex flex-wrap gap-2">
      <a href="panel.php?view=producto_form" class="btn btn-success btn-sm">+ Agregar Producto</a>
      <a href="exportar_productos.php" class="btn btn-outline-secondary btn-sm">Exportar</a>
      <button onclick="abrirImportador()" class="btn btn-primary btn-sm">Importar</button>
      <!--<a href="panel.php?view=producto_pack_form" class="btn btn-warning btn-sm">+ Crear Pack / Combo</a>-->
    </div>
  </div>


  <div class="table-responsive">
    <table id="tabla_productos" class="table table-hover table-bordered table-striped align-middle text-center" style="width: 100%;">
      <thead>
        <tr>
          <th style="text-align: center;">Imagen</th>
          <th style="text-align: left;">Nombre</th>
          <th style="text-align: left;">Descripción</th>
          <th style="text-align: center;">Precio</th>
          <th style="text-align: center;">Stock</th>
          <th style="text-align: center;">Categoría</th>
          <th style="text-align: center;">Activo</th>
          <th style="text-align: center;">Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($p = $result->fetch_assoc()): ?>
          <tr>
            <td style="text-align: center;">
              <?php if ($p['imagen_url']): ?>
                <img src="../images/productos/<?php echo htmlspecialchars($p['imagen_url']); ?>" alt="img" width="50">
              <?php endif; ?>
            </td>
            <td style="text-align: left;"><?php echo htmlspecialchars($p['nombre']); ?></td>
            <td class="descripcion-cell" title="<?php echo htmlspecialchars($p['descripcion']); ?>">
              <?php echo htmlspecialchars($p['descripcion']); ?>
            </td>
            <td style="text-align: center;">$<?php echo number_format($p['precio'], 0, ',', '.'); ?></td>
            <td style="text-align: center;"><?php echo $p['stock']; ?></td>
            <td style="text-align: center;"><?php echo $p['categoria']; ?></td>
            <td style="text-align: center;"><?php echo $p['activo'] ? 'Sí' : 'No'; ?></td>
            <td style="text-align: center;">
              <a href="panel.php?view=producto_form&id=<?= $p['id'] ?>" class="btn btn-outline-primary btn-sm rounded-circle" title="Editar">
                <i class="fas fa-pen"></i>
              </a>
              <a href="panel.php?view=eliminar_producto&id=<?= $p['id'] ?>" class="btn btn-outline-danger btn-sm rounded-circle" title="Eliminar" onclick="return confirm('¿Eliminar este producto?');">
                <i class="fas fa-trash"></i>
              </a>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>

  <form id="form-importar" enctype="multipart/form-data" style="display: none;">
    <input type="file" name="archivo" id="archivo-importar" accept=".xls,.xlsx" class="form-control">
  </form>

  <!-- DataTables -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css" />
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script>
    $(document).ready(function() {
      $('#tabla_productos thead tr')
        //.clone(true)
        .addClass('filters')
        .appendTo('#tabla_productos thead');

      let table = $('#tabla_productos').DataTable({
        responsive: true,
        orderCellsTop: true,
        // fixedHeader: true,
        language: {
          search: "🔍 Buscar:",
          lengthMenu: "Mostrar _MENU_ registros",
          info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
          paginate: {
            previous: "Anterior",
            next: "Siguiente"
          }
        },
        /* initComplete: function () {
           this.api().columns().every(function (i) {
             let column = this;
             let cell = $('.filters th').eq(i).empty();
             $('<input type="text" placeholder="Filtrar" style="width: 100%; padding: 4px;" />')
               .appendTo(cell)
               .on('keyup change', function () {
                 column.search($(this).val()).draw();
               });
           });
         }*/
      });
    });
  </script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    function abrirImportador() {
      Swal.fire({
        title: '📥 Importar productos desde Excel',
        html: `
      <input type="file" id="input-archivo" accept=".xls,.xlsx" class="swal2-file">
    `,
        confirmButtonText: 'Subir y procesar',
        showCancelButton: true,
        preConfirm: () => {
          const archivo = document.getElementById('input-archivo').files[0];
          if (!archivo) {
            Swal.showValidationMessage('⚠️ Debes seleccionar un archivo Excel');
            return false;
          }

          const formData = new FormData();
          formData.append('archivo', archivo);

          return fetch('importar_productos.php', {
              method: 'POST',
              body: formData
            }).then(response => response.text())
            .then(data => {
              return data;
            }).catch(() => {
              Swal.showValidationMessage('❌ Error al procesar el archivo');
            });
        }
      }).then(result => {
        if (result.isConfirmed && result.value) {
          Swal.fire('✅ ¡Proceso completo!', result.value, 'success').then(() => {
            location.reload();
          });
        }
      });
    }
  </script>
</div>