<?php
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Obtener todos los usuarios con nombre del negocio
$query = "SELECT u.id, u.nombre, u.email, u.rol, n.nombre AS negocio_nombre 
          FROM usuarios u
          LEFT JOIN negocios n ON u.negocio_id = n.id
          ORDER BY u.id DESC";

$result = $conn->query($query);
?>

<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mt-2 mb-3">
    <h4 class="mb-0 fw-semibold">
      <i class="fas fa-users me-2 text-primary"></i>Usuarios Registrados
    </h4>
    <div>
      <a href="panel.php?view=usuario_form" class="btn btn-success btn-sm">+ Agregar Usuario</a>
    </div>
  </div>

    
  <div class="table-responsive">
    <table id="tabla_usuarios" class="table table-hover table-bordered table-striped align-middle text-center" style="width: 100%;">
    <thead>
      <tr>
        <th>Nombre</th>
        <th>Email</th>
        <th>Negocio</th>
        <th>Rol</th>
        <th>Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($user = $result->fetch_assoc()): ?>
        <tr>
          <td><?php echo htmlspecialchars($user['nombre']); ?></td>
          <td><?php echo htmlspecialchars($user['email']); ?></td>
          <td><?php echo htmlspecialchars($user['negocio_nombre']); ?></td>
          <td><?php echo htmlspecialchars($user['rol']); ?></td>
          <td>
            <a href="panel.php?view=usuario_form&id=<?= $user['id'] ?>" class="btn btn-outline-primary btn-sm rounded-circle" title="Editar">
              <i class="fas fa-pen"></i>
            </a>
            <a href="panel.php?view=eliminar_usuario&id=<?= $user['id'] ?>" class="btn btn-outline-danger btn-sm rounded-circle" title="Eliminar" onclick="return confirm('¿Eliminar este usuario?');">
              <i class="fas fa-trash"></i>
            </a>
          </td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</div>

  <!-- DataTables -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css"/>
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script>
    $(document).ready(function () {
      $('#tabla_usuarios thead tr')
        //.clone(true)
        .addClass('filters')
        .appendTo('#tabla_usuarios thead');

      let table = $('#tabla_usuarios').DataTable({
        responsive: true,
        orderCellsTop: true,
        // fixedHeader: true,
        language: {
          search: "🔍 Buscar:",
          lengthMenu: "Mostrar _MENU_ registros",
          info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
          paginate: {
            previous: "Anterior",
            next: "Siguiente"
          }
        },
       /* initComplete: function () {
          this.api().columns().every(function (i) {
            let column = this;
            let cell = $('.filters th').eq(i).empty();
            $('<input type="text" placeholder="Filtrar" style="width: 100%; padding: 4px;" />')
              .appendTo(cell)
              .on('keyup change', function () {
                column.search($(this).val()).draw();
              });
          });
        }*/
      });
    });
  </script>