<?php
ob_start();

require_once '../config/config.php';
require_once '../mailer/deliciasdulcesysaladas.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

$pedido_id = $_GET['id'] ?? null;
$negocio_id = $_SESSION['negocio_id'];
$logoUrl = $_SESSION['logo_url'] ?? 'logo_default.png';

if (!$pedido_id) {
  die("Pedido no especificado.");
}

// Obtener pedido
$stmt = $conn->prepare("SELECT * FROM pedidos as ped  inner join negocios as neg on neg.id=ped.negocio_id WHERE ped.id = ? AND ped.negocio_id = ?;");
$stmt->bind_param("ii", $pedido_id, $negocio_id);
$stmt->execute();
$pedido = $stmt->get_result()->fetch_assoc();

if (!$pedido) {
  die("Pedido no encontrado.");
}

// Obtener items
$items = $conn->query("
  SELECT pi.*, p.nombre 
  FROM pedido_items pi 
  INNER JOIN productos p ON p.id = pi.producto_id 
  WHERE pi.pedido_id = $pedido_id
");

// Procesar cambio de estado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nuevo_estado = $_POST['estado'];
  $update = $conn->prepare("UPDATE pedidos SET estado = ? WHERE id = ? AND negocio_id = ?");
  $update->bind_param("sii", $nuevo_estado, $pedido_id, $negocio_id);

  if ($update->execute()) {
    if ($nuevo_estado === 'confirmado') {
      $items = $conn->query("SELECT producto_id, cantidad FROM pedido_items WHERE pedido_id = $pedido_id");

      $mov = $conn->prepare("INSERT INTO inventario_movimientos 
        (producto_id, negocio_id, tipo_movimiento, cantidad, motivo, usuario_id, stock_anterior, stock_actual) 
        VALUES (?, ?, 'venta', ?, ?, NULL, ?, ?)");

      while ($item = $items->fetch_assoc()) {
        $producto_id = $item['producto_id'];
        $cantidad = $item['cantidad'];
        $motivo = "Confirmación manual (Pedido #$pedido_id)";

        $stock_q = $conn->query("SELECT stock FROM productos WHERE id = $producto_id");
        $stock_anterior = (int) $stock_q->fetch_assoc()['stock'];
        $stock_actual = $stock_anterior - $cantidad;

        $mov->bind_param("iiisii", $producto_id, $negocio_id, $cantidad, $motivo, $stock_anterior, $stock_actual);
        $mov->execute();

        $conn->query("UPDATE productos SET stock = $stock_actual WHERE id = $producto_id");
      }
    }
    // Enviar correo con nuevo estado

    enviarCorreoEstado(
      $pedido['cliente_email'],
      $pedido['cliente_nombre'],
      $nuevo_estado,
      $pedido_id,
      $pedido['logo_url']
    );

    echo "<script>window.location.href = 'panel.php?view=pedidos&id=$pedido_id';</script>";
    exit;
  }
}
?>

<main class="mdl-layout__content">
  <div class="container">
    <h4>Datos del cliente</h4>
    <p><strong>Nombre:</strong> <?php echo htmlspecialchars($pedido['cliente_nombre']); ?></p>
    <p><strong>Teléfono:</strong> <?php echo $pedido['cliente_telefono']; ?></p>
    <p><strong>Dirección:</strong> <?php echo $pedido['cliente_direccion']; ?></p>

    <h4>Productos</h4>
    <table class="mdl-data-table mdl-js-data-table mdl-shadow--2dp">
      <thead>
        <tr>
          <th>Producto</th>
          <th>Cantidad</th>
          <th>Precio Unitario</th>
          <th>Subtotal</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($item = $items->fetch_assoc()): ?>
          <tr>
            <td><?php echo $item['nombre']; ?></td>
            <td><?php echo $item['cantidad']; ?></td>
            <td>$<?php echo number_format($item['precio_unitario'], 0, ',', '.'); ?></td>
            <td>$<?php echo number_format($item['cantidad'] * $item['precio_unitario'], 0, ',', '.'); ?></td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>

    <h5>Total: $<?php echo number_format($pedido['total'], 0, ',', '.'); ?></h5>

    <form method="POST" class="form-cambio">
      <label for="estado">Estado:</label>
      <select name="estado" class="mdl-textfield__input" required>
        <option value="pendiente" <?php if ($pedido['estado'] === 'pendiente') echo 'selected'; ?>>Pendiente</option>
        <option value="confirmado" <?php if ($pedido['estado'] === 'confirmado') echo 'selected'; ?>>Confirmado</option>
        <option value="preparando" <?php if ($pedido['estado'] === 'preparando') echo 'selected'; ?>>Preparando</option>
        <option value="preparado" <?php if ($pedido['estado'] === 'preparado') echo 'selected'; ?>>Preparado</option>
        <option value="listoRetiro" <?php if ($pedido['estado'] === 'listoRetiro') echo 'selected'; ?>>Listo para Retiro</option>
        <option value="despachado" <?php if ($pedido['estado'] === 'despachado') echo 'selected'; ?>>Despachado</option>
        <option value="entregado" <?php if ($pedido['estado'] === 'entregado') echo 'selected'; ?>>Entregado</option>
        <option value="cancelado" <?php if ($pedido['estado'] === 'cancelado') echo 'selected'; ?>>Cancelado</option>
      </select>
      <button class="mdl-button mdl-js-button mdl-button--raised mdl-button--colored" type="submit">
        Actualizar
      </button>

      <a class="ver-btn" href="imprimir_pedido.php?id=<?php echo $pedido['id']; ?>" target="_blank" title="Imprimir">🖨️</a>
    </form>
  </div>
</main>

<?php ob_end_flush(); ?>