<?php
session_start();
require_once 'config/config.php';

$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("Error de conexión.");
}

//$stmt = $conn->prepare("SELECT * FROM usuarios WHERE email = ? LIMIT 1");

$stmt = $conn->prepare("SELECT usr.id, usr.negocio_id, usr.nombre, usr.email, usr.rol, usr.password, neg.descripcion, neg.logo_url, neg.email, neg.telefono, neg.direccion, neg.horario_apertura, neg.horario_cierre,  neg.fecha_registro 
FROM usuarios as usr 
inner join negocios as neg on usr.negocio_id=neg.id
Where neg.activo = 1 and usr.email = ? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $usuario = $result->fetch_assoc();

    if (password_verify($password, $usuario['password'])) {
        // Éxito: guardar sesión
        $_SESSION['usuario_id'] = $usuario['id'];
        $_SESSION['negocio_id'] = $usuario['negocio_id'];
        $_SESSION['nombre'] = $usuario['nombre'];
        $_SESSION['rol'] = $usuario['rol'];
        $_SESSION['telefono_emp'] = $usuario['telefono'];
        $_SESSION['horario_apertura'] = $usuario['horario_apertura'];
        $_SESSION['horario_cierre'] = $usuario['horario_cierre'];
        $_SESSION['logo_emp'] = $usuario['logo_url'];




        header("Location: admin/panel.php");
        exit;
    } else {
        echo "❌ Contraseña incorrecta.";
    }
} else {
    echo "❌ Usuario no encontrado.";
}
